<?php

namespace App\User;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function role()
    {
        return $this->hasOne('Role');
    }

    public function account()
    {
        return $this->hasOne('Account');
    }

    public function feedactivities()
    {
        return $this->hasMany('Feedsactivity');
    }

}